from detect_methods.mink import mink
from detect_methods.sharded_likelihood import sharded_likelihood
from detect_methods.samia import samia

def detect_method(data, model, tokenizer, args):
    if args.method_name == "mink":
        print("Detecting using mink...")
        return mink(data, model, tokenizer, key_name=args.key_name, output_dir=args.output_dir)

    elif args.method_name == "sharded_likelihood":
        print("Detecting using sharded_likelihood...")
        return sharded_likelihood(
            data,
            args.model_name,
            tokenizer,
            log_file_path=args.log_file_path,
            context_len=args.sharded_likelihood_context_len,
            stride=args.sharded_likelihood_stride,
            num_shards=args.sharded_likelihood_num_shards,
            permutations_per_shard=args.sharded_likelihood_permutations_per_shard,
            output_dir=args.output_dir
        )
    elif args.method_name == "samia":
        print("Detecting using samia...")
        return samia(data, model, tokenizer, args)
    else:
        return None
    # TODO: add more methods here
